/*
	Signature Code
	Copyright © 2019 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA

	Signature Code - version 1.0 for Display Signature Web widget
	10 October, 2019
	Copyright © 2019 Harry Whitfield
	mailto:g6auc@arrl.net
*/

/*jslint bitwise, browser, devel, for */

/*property
    every, length, replace, some, split, toUpperCase
*/

/////////////////////////////////// File Signature Code //////////////////////////////////

var signatures;

var maxSigLength = 0;
var gCount = 32;

/*
var signatures = [	// sample
	["47 49 46 38 37 61", "GIF87a", 0, "gif", "Image file encoded in the Graphics Interchange Format (GIF)[7]"],
	["47 49 46 38 39 61", "GIF89a", 0, "gif", "Image file encoded in the Graphics Interchange Format (GIF)[7]"],
	["FF D8 FF DB", "ÿØÿÛ", 0, "jpg, jpeg", "JPEG raw or in the JFIF or Exif file format"],
	["FF D8 FF E0 00 10 4A 46 49 46 00 01", "ÿØÿà..JFIF..", 0, "jpg, jpeg", "JPEG raw or in the JFIF or Exif file format"],
	["FF D8 FF EE", "ÿØÿî", 0, "jpg, jpeg", "JPEG raw or in the JFIF or Exif file format"],
	["25 50 44 46 2d", "%PDF-", 0, "pdf", "PDF document[15]"],
	["89 50 4E 47 0D 0A 1A 0A", ".PNG....", 0, "png", "Image encoded in the Portable Network Graphics format[13]"]
];
*/

function matches(data, start, sig) {	// allows for "??"  hex bytes
	return sig.split("").every(function (c, i) {
		return ((c === data[start + i]) || (c === "?"));
	});
}

function fileTypeFromSignature(data) {
	var osig;
	var sig;
	var start;
	var extn;
	var desc;

	data = data.replace(/\u0020/g, "").toUpperCase();

	var res = signatures.some(function (ele) {	// (ele, i)
		osig = ele[0].toUpperCase();
		sig = osig.replace(/\u0020/g, "");
		start = ele[2];
		extn = ele[3];
		desc = ele[4];

		if (sig.length > maxSigLength) {
			maxSigLength = sig.length;
		}

		return matches(data, 2 * start, sig);
	});

	if (maxSigLength / 2 > gCount) {
		alert("Warning: gCount too small: " + gCount + " < " + maxSigLength / 2);
	}

	if (res) {
		return [osig, extn, desc];
	}
	return null;
}
